//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3

import wesual.Controls 1.0

import wesual.data.Core        1.0
import wesual.data.FoodService 1.0

ToolButton {
    id : picker

    property Context context

    signal productPicked(FoodServiceProduct product)

    action : Action {
        text : qsTrId("92d71d7c3982e3b9")
        iconName : "add"
        onTriggered : flyout.show()
    }
    down : flyout.popupVisible

    FoodServiceProductPopup {
        id : flyout

        context : picker.context
        onProductPicked : picker.productPicked(product)
        onPopupVisibleChanged : {
            if (popupVisible && popupItem) {
                popupItem.resetFilter();
            }
        }
    }
}
